//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include  "..\Defines.mqh"
//+------------------------------------------------------------------+
#define def_ShortName 	"Mini Chat"
#define def_MaxRows		256
#define def_FontName		"Lucida Console"
#define def_FontSize		12
#define def_SizeControls (m_txtHeight + 6)
#define macroColorRGBA(A) ((uint)((0xFF << 24) | (A & 0x00FF00) | ((A & 0xFF0000) >> 16) | ((A & 0x0000FF) << 16)))
//+------------------------------------------------------------------+
class C_Chat
{
	private	:
		long   m_id;
		int    m_sub;
		int	 m_txtHeight;
		bool	 m_full;
		ushort m_Width,
				 m_Height,
				 m_index;
		uint	 m_Pixel[];
		string m_ObjEdit,
				 m_ObjBtn,
				 m_ObjPanel;
		struct st0
		{
			string info;
			bool	 loc;
		}m_Msgs[def_MaxRows + 1];
//+------------------------------------------------------------------+
		void Add(string szMsg, bool isloc = false)
		{
			m_Msgs[m_index].info = szMsg;
			m_Msgs[m_index].loc = isloc;
			if ((++m_index) > def_MaxRows)
			{
				m_full = true;
				m_index = 0;
			}
			Paint();
		};
//+------------------------------------------------------------------+
		void Paint(void)
		{
			int max, count, p0, p1;
			
			ArrayInitialize(m_Pixel, macroColorRGBA(clrBlack));
			if ((p0 = m_Height - def_SizeControls) < 0) return;
			max = (int)(floor(p0 / (m_txtHeight * 1.0)));
			p1 = m_index - max;
			if (m_full)
				count = (max > def_MaxRows ? m_index + 1 : (p1 > 0 ? p1 : (def_MaxRows + p1 + 1)));
			else
				count = (p1 > 0 ? p1 : 0);			
			for (ushort row = 0; row < p0; count++)
			{
				count = (count > def_MaxRows ? 0 : count);
				if (count == m_index) break;
				TextOut(m_Msgs[count].info, 2, row, 0, m_Pixel, m_Width, m_Height, macroColorRGBA(m_Msgs[count].loc ? clrSkyBlue : clrLime), COLOR_FORMAT_ARGB_NORMALIZE);
				row += (ushort) m_txtHeight;
			}
			ResourceCreate("::" + m_ObjPanel, m_Pixel, m_Width, m_Height, 0, 0, 0, COLOR_FORMAT_ARGB_NORMALIZE);
			ChartRedraw();
		}
//+------------------------------------------------------------------+
		void CreateObjEdit(const string szArg)
		{
			ObjectCreate(m_id, szArg, OBJ_EDIT, m_sub, 0, 0);
			ObjectSetInteger(m_id, szArg, OBJPROP_XDISTANCE, 2);
			ObjectSetInteger(m_id, szArg, OBJPROP_YDISTANCE, 0);
			ObjectSetInteger(m_id, szArg, OBJPROP_YSIZE, def_SizeControls);
			ObjectSetString(m_id, szArg, OBJPROP_FONT, def_FontName);
			ObjectSetInteger(m_id, szArg, OBJPROP_FONTSIZE, def_FontSize);
			ObjectSetInteger(m_id, szArg, OBJPROP_BGCOLOR, clrDarkGray);
			ObjectSetInteger(m_id, szArg, OBJPROP_COLOR, clrBlack);
			ObjectSetInteger(m_id, szArg, OBJPROP_BORDER_COLOR, clrNavy);
		}
//+------------------------------------------------------------------+
		void CreateObjButton(const string szArg, const string szTxt)
		{
			ObjectCreate(m_id, szArg, OBJ_BUTTON, m_sub, 0, 0);
			ObjectSetInteger(m_id, szArg, OBJPROP_YDISTANCE, 0);
			ObjectSetInteger(m_id, szArg, OBJPROP_XSIZE, 70);
			ObjectSetInteger(m_id, szArg, OBJPROP_YSIZE, def_SizeControls);
			ObjectSetString(m_id, szArg, OBJPROP_FONT, def_FontName);
			ObjectSetInteger(m_id, szArg, OBJPROP_FONTSIZE, def_FontSize);
			ObjectSetInteger(m_id, szArg, OBJPROP_BGCOLOR, clrSkyBlue);
			ObjectSetInteger(m_id, szArg, OBJPROP_COLOR, clrBlack);
			ObjectSetInteger(m_id, szArg, OBJPROP_BORDER_COLOR, clrBlack);
			ObjectSetString(m_id, szArg, OBJPROP_TEXT, szTxt);
		}
//+------------------------------------------------------------------+
		void CreateObjPanel(const string szArg)
		{		
			ObjectCreate(m_id, szArg, OBJ_BITMAP_LABEL, m_sub, 0, 0);
			ObjectSetInteger(m_id, szArg, OBJPROP_XDISTANCE, 2);
			ObjectSetInteger(m_id, szArg, OBJPROP_YDISTANCE, m_txtHeight + 8);
			ObjectSetString(m_id, szArg, OBJPROP_BMPFILE, "::" + m_ObjPanel);
		}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_Chat()
			:m_index(0),
			 m_full(false),
			 m_Width(0),
			 m_Height(0)
		{			
			int tmp;
			
			m_sub = ChartWindowFind(m_id = ChartID(), def_ShortName);
			TextSetFont(def_FontName, -10 * def_FontSize, 0, 0);
			TextGetSize("M", tmp, m_txtHeight);
			CreateObjEdit(m_ObjEdit = def_ShortName + " Edit" + (string)ObjectsTotal(m_id));
			CreateObjButton(m_ObjBtn = def_ShortName + " Button" + (string)ObjectsTotal(m_id), "Send");
			CreateObjPanel(m_ObjPanel = def_ShortName + " Panel" + (string)ObjectsTotal(m_id));
		}
//+------------------------------------------------------------------+
		~C_Chat()
		{
			ObjectsDeleteAll(m_id, def_ShortName);
		};
//+------------------------------------------------------------------+
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
		{
			switch(id)
			{
				case CHARTEVENT_CHART_CHANGE:
					m_Width = (ushort)ChartGetInteger(m_id, CHART_WIDTH_IN_PIXELS, m_sub);
					m_Height = (ushort)ChartGetInteger(m_id, CHART_HEIGHT_IN_PIXELS, m_sub);
					ObjectSetInteger(m_id, m_ObjEdit, OBJPROP_XSIZE, m_Width - 75);
					ObjectSetInteger(m_id, m_ObjBtn, OBJPROP_XDISTANCE, m_Width - 72);
					ObjectSetInteger(m_id, m_ObjPanel, OBJPROP_XSIZE, m_Width - 4);
					ObjectSetInteger(m_id, m_ObjPanel, OBJPROP_YSIZE, m_Height - 4);
					ArrayResize(m_Pixel, m_Width * m_Height);
					Paint();
					break;
				case CHARTEVENT_OBJECT_CLICK:
					if (sparam == m_ObjBtn)
					{
						string sz0 = ObjectGetString(m_id, m_ObjEdit, OBJPROP_TEXT);
						if (sz0 != "")
						{
							EventChartCustom(m_id, evChatWriteSocket, 0, 0, sz0);
							Add(sz0, true);
							ObjectSetString(m_id, m_ObjEdit, OBJPROP_TEXT, "");
							ObjectSetInteger(m_id, m_ObjBtn, OBJPROP_STATE, 0);
						}						
					}
					break;
				case CHARTEVENT_CUSTOM + evChatReadSocket:
					Add(sparam);
					break;
				}
		}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef macroColorRGBA
#undef def_MaxRows
//+------------------------------------------------------------------+